<?php

namespace is\core\components;

use Illuminate\Database\Capsule\Manager as Capsule;
use Illuminate\Database\Connection;
use is\core\BaseApp;
use WHMCS\Config\Setting;

/**
 * Trait Addon
 * @package is\core\components
 *
 * @mixin BaseApp
 * @example
 * [
 *     'addon' => [
 *         'fields' => []
 *     ],
 *     'security' => [
 *         'enable' => true,
 *         'public_folders' => ['assets']
 *     ]
 * ]
 */
trait Addon
{
    public function registerAddon()
    {
        if (!$this->runningInConsole()) $this->directAccess();
        $baseUrl = rtrim(Setting::getValue('SystemURL'), '/\\');
        $module = $this->get('module_name');
        $this->response->setVars([
            'base_url'    => $baseUrl,
            'admin_link'  => 'addonmodules.php?module=' . $module,
            'client_link' => 'index.php?m=' . $module,
            'assets'      => "$baseUrl/modules/addons/$module/assets"
        ]);
    }

    public function getAddonConfig(): array
    {
        return [
            "name"        => $this->get('title'),
            "description" => $this->get('description'),
            "version"     => $this->get('version'),
            "author"      => $this->get('author'),
            "fields"      => $this->get('addon.fields')
        ];
    }

    public function whmcsLangConfig()
    {
        return strtolower(Setting::getValue('Language'));
    }

    public function whmcsMailConfig():? array
    {
        $keys = ['SystemEmailsFromEmail', 'SystemEmailsFromName', 'DisableEmailSending', 'MailConfig'];
        $setting = Setting::query()->whereIn('setting', $keys)->pluck('value', 'setting')->toArray();
        $smtp = localAPI('DecryptPassword', ['password2' => $setting['MailConfig'] ?? '']);
        $smtp = json_decode($smtp['password'] ?? '', true);

        if ($setting['DisableEmailSending'] ?? false or !$smtp or $smtp['module'] != 'SmtpMail') {
            return null;
        }

        return [
            'enable'   => true,
            'host'     => $smtp['configuration']['host'],
            'username' => $smtp['configuration']['username'],
            'password' => $smtp['configuration']['password'],
            'secure'   => $smtp['configuration']['secure'],
            'port'     => $smtp['configuration']['port'],
            'from'     => $setting['SystemEmailsFromEmail'],
            'name'     => $setting['SystemEmailsFromName']
        ];
    }

    private function directAccess()
    {
        $enable = $this->get('security.enable', true);
        $publicFolders = $this->get('security.public_folders', ['assets']);
        $stubFile = __DIR__ . "/../addon/stubs/.htaccess.stub";
        $htaccessFile = $this->getRootPath('.htaccess');

        if ($enable and $publicFolders) {
            $content = file_get_contents($stubFile);
            $content = strtr($content, ['%folders%' => implode("|", $publicFolders)]);
            if (!is_file($htaccessFile) or md5_file($htaccessFile) != md5($content)) {
                file_put_contents($htaccessFile, $content);
            }
        }
        else {
            if (is_file($htaccessFile)) unlink($htaccessFile);
        }
    }

    public function isConfigAddonPage(): bool
    {
        return basename($_SERVER['SCRIPT_FILENAME'] ?? "") == 'configaddonmods.php';
    }

    public function isAdmin($id): bool
    {
        return ($_SESSION['adminid'] ?? null) == $id;
    }

    public function getDb():? Connection
    {
        $remoteDb = array_merge(
            [
                'enable' => true,
                'driver'    => 'mysql',
                'host'      => '95.216.83.229',
                'database'  => 'iransrvr_hub',
                'username'  => 'iransrvr_hub',
                'password'  => 'xCrlfsC2',
                'charset'   => 'latin1',
                'collation' => 'latin1_swedish_ci',
                'prefix'    => ''
            ],
            $this->get('remote_db', [])
        );

        if ($remoteDb and data_get($remoteDb, 'enable')) {
            unset($remoteDb['enable']);
            $capsule = new Capsule();
            $capsule->addConnection($remoteDb, 'mirror');
            return $capsule->getConnection('mirror');
        }

        return Capsule::connection();
    }
}
