<?php

namespace is\core\shared;

use ArgumentCountError;

trait Obj
{
    public function populate(array $config, $autoFill = []): array
    {
        if (is_string($autoFill)) {
            $autoFill = (array) $autoFill;
        }

        foreach ($config as $k => $v) {
            if (isset($autoFill[$k])) $this->{$autoFill[$k]} = $config[$autoFill[$k]] = $v;
            else $this->$k = $v;
        }

        return $config;
    }

    public function requiredArgs($args)
    {
        $requires = func_get_args();
        array_shift($requires);
        foreach ($requires as $key) {
            if (!Arr::has($args, $key)) {
                throw new ArgumentCountError(sprintf(
                    "Too few arguments to function %s::__construct(%s)",
                    static::class, $key
                ));
            }
        }
    }
}