<?php

namespace is\core\response;

use is\core\shared\Obj;
use Smarty as SmartyEngine;

class Smarty implements Section
{
    use Obj;

    public $tpl;
    public $vars = [];
    private $smarty;

    public function __construct($config = [])
    {
        $config = $this->populate($config, ['tpl', 'vars']);
        $this->requiredArgs($config, 'tpl');
    }

    public function render(array $vars = []): string
    {
        if (!$this->smarty) $this->smarty = new SmartyEngine();
        $this->smarty->assign(array_merge($vars, $this->vars));
        ob_start();
        $this->smarty->display($this->tpl);
        return ob_get_clean();
    }
}