<?php
namespace is\core\routes;

use is\core\shared\Obj;

class Route implements RouteInterface
{
    use Obj;

    public $action;
    public $controller;
    public $keyName = 'action';

    public function __construct($config = [])
    {
        $config = $this->populate($config, ['action', 'controller']);
        $this->requiredArgs($config, 'action', 'controller');
    }

    public function input(): string
    {
        return $_GET[$this->keyName] ?? '';
    }

    public function match():? array
    {
        if ($this->input() === $this->action) {
            return is_string($this->controller)
                ? [$this->controller, '__invoke']
                : $this->controller;
        }
        return null;
    }
}
