<?php

namespace is\core\addon;

use Composer\Script\Event;
use is\core\shared\Str;

class Composer
{
    public static function generate_addon(Event $event)
    {
        $stubDir = __DIR__ . "/stubs";
        $rootDir = dirname($event->getComposer()->getConfig()->get('vendor-dir'));
        $name = Str::basename($rootDir);
        $composer_json = "$rootDir/composer.json";

        if (is_file($composer_json)) {
            foreach (['App' => 'App', 'addon_name' => $name] as $src => $dest) {
                $content = file_get_contents("$stubDir/$src.stub");
                $content = strtr($content, ['%addon_name%' => $name]);
                file_put_contents("$rootDir/$dest.php", $content);
            }

            file_put_contents($composer_json, strtr(file_get_contents($composer_json), ['%addon_name%' => $name]));
        }
    }
}