<?php

namespace is\core\routes;

use is\core\shared\Obj;

class DynamicRouting implements RouteInterface
{
    use Obj;

    public $keyName = 'action';
    public $namespace;

    public function __construct($config = [])
    {
        $config = $this->populate($config, 'namespace');
        $this->requiredArgs($config, 'namespace');
    }

    public function input(): string
    {
        return $_GET[$this->keyName] ?? '';
    }

    public function match():? array
    {
        if ($this->input()) {
            $parts = explode('/', $this->input(), 2);
            $basename = ucwords(str_replace(['-', '_'], ' ', $parts[0]));
            $basename = str_replace(' ', '', $basename) . "Controller";
            $class = $this->namespace . '\\' . $basename;
            $method = $parts[1] ?? '__invoke';
            if (class_exists($class) and method_exists($class, $method)) {
                return [$class, $method];
            }
        }
        return null;
    }
}
