<?php
declare(strict_types=1);

use PHPUnit\Framework\TestCase;
use is\core\BaseApp;

class AppTest extends TestCase
{
    /** @var BaseApp */
    public $app;

    protected function setUp(): void
    {
        $this->app = new class extends BaseApp
        {
            public function config(): array
            {
                return [
                    'module_name' => 'test',
                    'title'       => 'test app',
                    'description' => 'just for test',
                    'version'     => '1.0',
                    'author'      => 'Pooya'
                ];
            }
        };
    }

    public function testInitWithError(): void
    {
        $this->expectException(ArgumentCountError::class);
        new class extends BaseApp
        {
            public function config(): array
            {
                return [];
            }
        };
    }

    public function testCore(): void
    {
        $this->assertEquals('test', $this->app->get('module_name'));
        $this->app->set('test.start', new DateTime());
        $this->assertInstanceOf(DateTime::class, $this->app->get('test.start'));
    }
}