<?php

namespace is\core\components;

use is\core\BaseApp;
use is\core\response\Response as ResponseManager;

/**
 * Trait Response
 * @package is\core\components
 *
 * @mixin BaseApp
 */
trait Response
{
    /** @var ResponseManager */
    public $response;

    public function registerResponse()
    {
        $class = $this->get('response.class', ResponseManager::class);
        $this->response = new $class();
        $this->response->setVars([
            'root'        => $this->getRootPath(),
            'module_name' => $this->get('module_name'),
            'base_url'    => $this->get('base_url', '')
        ]);
    }

    public function terminateResponse()
    {
        if ($this->response->hasJson and $this->get('response.exitJson', true)) {
            exit();
        }
    }

    public function getViewPath($path = ''): string
    {
        $path = ltrim($path, "/\\");
        return $this->getRootPath($this->get('response.viewPath', 'templates') . "/$path");
    }
}
