<?php

namespace is\core\controllers;

use is\core\BaseApp;
use is\core\components\Log;
use is\core\shared\File;

/**
 * Class LogsController
 * @package is\core\controllers
 *
 * @property BaseApp|Log $app
 */
class LogsController extends BaseController
{
    public function __invoke(): string
    {
        $path = $this->app->getLogPath();
        $files = File::list($path, true);
        $response = $files ? nl2br(file_get_contents(end($files))) : "";
        return sprintf("<div style='font-family: monospace'>%s</div>", $response);
    }
}