<?php

namespace is\core\components;

use is\core\BaseApp;
use is\core\controllers\LogsController;
use is\core\routes\Route;
use is\core\shared\File;
use is\core\shared\Str;

/**
 * Trait Log
 * @package is\core\components
 *
 * @mixin BaseApp
 */
trait Log
{
    public function registerLog()
    {
        $this->addRoute(new Route(['logs', LogsController::class]));
    }

    public function info(string $description, array $data = []): void
    {
        $this->log('info', $description, $data);
    }

    public function error(string $description, array $data = []): void
    {
        $this->log('error', $description, $data);
    }

    public function getLogPath($path = ''): string
    {
        $path = ltrim($path, "/\\");
        $return = $this->get('log.path', $this->getRootPath("storage/logs"));
        return Str::normalizePath("$return/$path");
    }

    private function log(string $level, string $description, array $data = []): void
    {
        $today = date('Y-m-d');
        $now = date('Y-m-d H:i:s');
        $path = $this->getLogPath();

        if (!is_dir($path)) mkdir($path, 0755, true);
        $filename = sprintf("$path/log-%s.log", $today);
        file_put_contents(
            $filename,
            sprintf(
                "[%s] %s '%s': %s" . PHP_EOL,
                $now, $level, $description, $data ? json_encode($data) : ''
            ),
            FILE_APPEND
        );
        $this->logGC();
    }

    private function logGC(): void
    {
        $days = $this->get('log.days', 15);
        if (!$days) return;

        $path = $this->getLogPath();
        foreach (File::list($path, true) as $filename) {
            if (
                substr($filename, -4) == '.log' and
                time() - filectime($filename) > $days * 86400
            ) {
                @ unlink($filename);
            }
        }
    }
}