<?php

namespace is\core\components;

use is\core\BaseApp;
use is\core\response\Response as ResponseManager;
use is\core\shared\Str;

/**
 * Trait Response
 * @package is\core\components
 *
 * @mixin BaseApp
 */
trait Response
{
    /** @var ResponseManager */
    public $response;

    public function registerResponse()
    {
        $this->setComponent('response', $this->get('response.class', ResponseManager::class));
    }

    public function getViewPath($path = ''): string
    {
        $path = ltrim($path, "/\\");
        return $this->getRootPath($this->get('response.viewPath', 'templates')."/$path");
    }
}