<?php

namespace is\core\response;

use is\core\shared\Obj;
use Smarty as SmartyEngine;

class Smarty implements Section
{
    use Obj;

    public $tpl;
    public $vars = [];

    public function __construct($config = [])
    {
        $this->populate($config, ['tpl', 'vars']);
        $this->requiredArgs('tpl');
    }

    public function render(array $vars = []): string
    {
        $smarty = new SmartyEngine();
        $smarty->assign(array_merge($vars, $this->vars));
        ob_start();
        $smarty->display($this->tpl);
        return ob_get_clean();
    }
}