<?php

namespace is\core\components;

use is\core\BaseApp;
use is\core\response\Response as ResponseManager;

/**
 * Trait Response
 * @package is\core\components
 *
 * @mixin BaseApp
 */
trait Response
{
    /** @var ResponseManager */
    public $response;

    public function registerResponse()
    {
        $this->setComponent('response', $this->get('response.class', ResponseManager::class));
    }

    public function getViewDir(): string
    {
        return $this->getRootDir() . "/" . $this->get('response.viewPath', 'templates');
    }
}