<?php
declare(strict_types=1);

use PHPUnit\Framework\TestCase;
use is\core\shared\Arr;

final class ArrTest extends TestCase
{
    public function testCommonGetBehaviors(): void
    {
        $target = [
            'array' => true,
            'users' => [
                ['name' => 'foo', 'age' => 20, 'kids' => ['aa', 'bb'], 'country' => 'ca'],
                ['name' => 'bar', 'age' => 30, 'kids' => ['cc', 'dd']]
            ],
            'anything',
            'meta' => [
                'total' => 2
            ]
        ];
        $this->assertEquals($target, Arr::get($target));
        $this->assertEquals(null, Arr::get($target, ''));
        $this->assertEquals(false, Arr::get($target, 'object', false));
        $this->assertEquals(2, Arr::get($target, 'meta.sum', 2));
        $this->assertEquals(true, Arr::get($target, 'array'));
        $this->assertEquals(20, Arr::get($target, 'users.0.age'));
        $this->assertEquals(2, Arr::get($target, 'meta.total'));
        $this->assertEquals($target, Arr::get($target, '*'));
        $this->assertEquals(['foo', 'bar'], Arr::get($target, 'users.*.name'));
        $this->assertEquals('default', Arr::get($target, 'users.*.', 'default'));
        $this->assertEquals(['ca'], Arr::get($target, 'users.*.country'));
        $this->assertEquals(['bb', 'dd'], Arr::get($target, 'users.*.kids.1'));
    }

    public function testCommonSetBehaviors(): void
    {
        $target = [
            'foo' => 'bar',
            'pop' => [
                'test' => [1, 2, 125],
                'hex' => ['blue' => '#0000FF']
            ],
            'apple'
        ];
        $this->assertEquals(147, Arr::set($target, 'foo', 147));
    }
}