<?php

namespace is\core\response;

use is\core\BaseApp;
use is\core\shared\Obj;

class Response
{
    use Obj;

    /** @var BaseApp */
    public $app;

    public $httpStatus = [
        404 => "NOT FOUND"
    ];

    private $statusCode = 200;
    private $vars = [];

    /** @var Section[][] */
    private $sections = [
        'before' => [],
        'main'   => [],
        'after'  => []
    ];

    public $partial = false;

    public function __construct($config = [])
    {
        $this->populate($config, 'app');
        $this->requiredArgs('app');
    }

    public function setVars($vars): self
    {
        if (is_array($vars)) $this->vars = array_merge($this->vars, $vars);
        else $this->vars[$vars] = func_get_args()[1] ?? null;
        return $this;
    }

    public function append(Section $section): self
    {
        $this->sections['after'][] = $section;
        return $this;
    }

    public function prepend(Section $section): self
    {
        $this->sections['before'][] = $section;
        return $this;
    }

    public function setContent(Section $section): self
    {
        if ($section instanceof Json) {
            $this->app->exiting();
            $this->partial = true;
        }

        $this->sections['main'][0] = $section;
        return $this;
    }

    public function view($tpl, $vars = []): Response
    {
        return $this->setContent(new Smarty([$tpl, $vars]));
    }

    public function json(array $array): Response
    {
        return $this->setContent(new Json([$array]));
    }

    public function raw(string $text): Response
    {
        return $this->setContent(new PlainText([$text]));
    }

    public function setStatus($code): self
    {
        $this->statusCode = $code;
        return $this;
    }

    public function render(): string
    {
        $output = "";
        foreach ($this->sections as $group) {
            foreach ($group as $section) {
                $output .= $section->render($this->vars);
            }
        }
        http_response_code($this->statusCode);
        return $output;
    }

    public function partial(): string
    {
        $output = isset($this->sections['main'][0])
            ? $this->sections['main'][0]->render($this->vars)
            : "";
        http_response_code($this->statusCode);
        return $output;
    }
}