<?php

namespace is\core\components;

use is\core\BaseApp;
use is\core\shared\Arr;
use ReflectionClass;

/**
 * Trait Core
 * @package is\core\components
 *
 * @mixin BaseApp
 */
trait Core
{
    private static $instances = [];
    public $config = [];
    abstract public function config(): array;

    /** @return static */
    public static function instance(): self
    {
        if (isset(self::$instances[static::class])) {
            return self::$instances[static::class];
        }
        return self::$instances[static::class] = new static();
    }

    public function get(string $key, $default = null)
    {
        return Arr::get($this->config, $key, $default);
    }

    public function getRootDir(): string
    {
        $appClass = new ReflectionClass($this);
        return dirname($appClass->getFileName());
    }

    public function run(): string
    {
        $route = $this->findRoute();
        [$controller, $action] = $route;

        $controller = new $controller($this);
        $response = $controller->$action();

        if (is_array($response)) $this->response->json($response);
        else if (is_string($response)) $this->response->raw($response);

        return $this->response->render();
    }
}