<?php

namespace is\core\components;

use is\core\BaseApp;

/**
 * Trait Addon
 * @package is\core\components
 *
 * @mixin BaseApp
 */
trait Addon
{
    public function registerAddon()
    {
        $this->directAccess();
        $this->response->setVars([
            'root'        => $this->getRootDir(),
            'admin_link'  => 'addonmodules.php?module=' . $this->get('module_name'),
            'client_link' => 'index.php?m=' . $this->get('module_name')
        ]);
    }

    public function getAddonConfig(): array
    {
        return [
            "name"        => $this->get('title'),
            "description" => $this->get('description'),
            "version"     => $this->get('version'),
            "author"      => $this->get('author'),
            "fields"      => $this->get('addon.fields')
        ];
    }

    private function directAccess()
    {
        $enable = $this->get('security.enable', true);
        $publicFolders = $this->get('security.public_folders', ['assets']);
        $stubFile = __DIR__ . "/../addon/stubs/.htaccess.stub";
        $htaccessFile = $this->getRootDir() . "/.htaccess";

        if ($enable and $publicFolders) {
            $content = file_get_contents($stubFile);
            $content = strtr($content, ['%folders%' => implode("|", $publicFolders)]);
            if (!is_file($htaccessFile) or md5_file($htaccessFile) != md5($content)) {
                file_put_contents($htaccessFile, $content);
            }
        }
        else {
            if (is_file($htaccessFile)) unlink($htaccessFile);
        }
    }
}