<?php

namespace is\core\shared;

use ArgumentCountError;

trait Obj
{
    public function populate(array $config, $autoFill = [])
    {
        if (is_string($autoFill)) {
            $autoFill = (array) $autoFill;
        }

        foreach ($config as $k => $v) {
            if (isset($autoFill[$k])) $this->{$autoFill[$k]} = $v;
            else $this->$k = $v;
        }
    }

    public function requiredArgs()
    {
        $requires = func_get_args();
        foreach ($requires as $key) {
            $value = Arr::get($this, $key);
            if (empty($value)) {
                throw new ArgumentCountError(sprintf(
                    "Too few arguments to function %s::__construct(%s)",
                    static::class, $key
                ));
            }
        }
    }
}