<?php

namespace is\core\response;

class Response
{
    public $httpStatus = [
        404 => "NOT FOUND"
    ];

    private $statusCode = 200;
    private $vars = [];

    /** @var Section[][] */
    private $sections = [
        'before' => [],
        'main'   => [],
        'after'  => []
    ];

    public function setVars($vars): self
    {
        if (is_array($vars)) $this->vars = array_merge($this->vars, $vars);
        else $this->vars[$vars] = func_get_args()[1] ?? null;
        return $this;
    }

    public function append(Section $section): self
    {
        $this->sections['after'][] = $section;
        return $this;
    }

    public function prepend(Section $section): self
    {
        $this->sections['before'][] = $section;
        return $this;
    }

    public function setContent(Section $section): self
    {
        $this->sections['main'][] = $section;
        return $this;
    }

    public function setStatus($code): self
    {
        $this->statusCode = $code;
        return $this;
    }

    public function render(): string
    {
        $output = "";
        foreach ($this->sections as $group) {
            foreach ($group as $section) {
                $output .= $section->render($this->vars);
            }
        }
        http_response_code($this->statusCode);
        return $output;
    }
}