<?php

namespace is\core\controllers;

use is\core\BaseApp;
use is\core\response\Response;
use is\core\response\Smarty;

class BaseController
{
    /** @var BaseApp */
    protected $app;

    public function __construct(BaseApp $app)
    {
        $this->app = $app;
    }

    public function response($tpl, $vars = []): Response
    {
        return $this->app->response->setContent(new Smarty([$tpl, $vars]));
    }
}