<?php

namespace is\core\response;

class Response
{
    public $httpStatus = [
        404 => "NOT FOUND"
    ];

    private $statusCode = 200;
    private $output = '';
    private $vars = [];

    public function setVars($vars): self
    {
        if (is_array($vars)) $this->vars = array_merge($this->vars, $vars);
        else $this->vars[$vars] = func_get_args()[1] ?? null;
        return $this;
    }

    public function setOutput($output): self
    {
        $this->output = $output;
        return $this;
    }

    public function setStatus($code): self
    {
        $this->statusCode = $code;
        return $this;
    }

    public function render(): string
    {
        http_response_code($this->statusCode);
        return $this->output;
    }
}