<?php

namespace is\core\components;

use is\core\BaseApp;
use ReflectionClass;

/**
 * Trait Addon
 * @package is\core\components
 *
 * @mixin BaseApp
 */
trait Addon
{
    public function registerAddon()
    {
        $appClass = new ReflectionClass($this);
        $this->response->setVars([
            'root'        => dirname($appClass->getFileName()),
            'admin_link'  => 'addonmodules.php?module=' . $this->get('module_name'),
            'client_link' => 'index.php?m=' . $this->get('module_name')
        ]);
    }

    public function getAddonConfig(): array
    {
        return [
            "module_name" => $this->get('module_name'),
            "name"        => $this->get('title'),
            "description" => $this->get('description'),
            "version"     => $this->get('version'),
            "author"      => $this->get('author'),
            "fields"      => $this->get('addon.fields')
        ];
    }
}