<?php

namespace is\core;

use is\core\components\Addon;
use is\core\components\Core;
use is\core\components\ErrorHandler;
use is\core\components\Response;
use is\core\components\Router;
use is\core\shared\Initiator;
use is\core\shared\Obj;

/**
 * Class BaseApp
 * @package is\core
 *
 * @example
 * [
 *     'name'        => 'sample app',
 *     'description' => 'this is a sample app',
 *     'version'     => '1.0',
 *     'author'      => 'Pooya <p.eraghi@greenweb.ir>',
 *     'routes' => [],
 *     'router' => [
 *         'node' => Route::class,
 *         'error' => ErrorController::class
 *     ],
 *     'response' => [
 *         'class' => Response::class
 *     ],
 *     'addon' => [
 *         'fields' => []
 *     ]
 * ]
 *
 */
abstract class BaseApp
{
    use Obj, Initiator, ErrorHandler, Core, Router, Response, Addon;

    public function __construct()
    {
        $this->config = $this->config();
        $this->callTraitsMethod('register');
        $this->callTraitsMethod('boot');
        $this->requiredArgs('config.module_name', 'config.title', 'config.description', 'config.version', 'config.author');
    }
}