<?php

namespace is\core\components;

use is\core\BaseApp;

/**
 * Trait Log
 * @package is\core\components
 *
 * @mixin BaseApp
 */
trait Log
{
    public function info(string $description, array $data = []): void
    {
        $this->log('info', $description, $data);
    }

    public function error(string $description, array $data = []): void
    {
        $this->log('error', $description, $data);
    }

    private function log(string $level, string $description, array $data = []): void
    {
        $today = date('Y-m-d');
        $now = date('Y-m-d H:i:s');
        $path = $this->get('log.path', $this->getRootPath("storage/logs"));

        if (!is_dir($path)) mkdir($path, 0755, true);
        $filename = sprintf("$path/log-%s.log", $today);
        file_put_contents(
            $filename,
            sprintf(
                "[%s] %s '%s': %s" . PHP_EOL,
                $now, $level, $description, $data ? json_encode($data) : ''
            ),
            FILE_APPEND
        );
    }
}