<?php
namespace is\core\console;

use is\core\routes\RouteInterface;
use is\core\shared\Obj;

class Command implements RouteInterface
{
    use Obj;

    public $action;
    public $command;

    public function __construct($config = [])
    {
        $this->populate($config, ['action', 'command']);
        $this->requiredArgs($config, 'action', 'command');
    }

    public function match():? array
    {
        if (isset(Input::$argv[1]) and Input::$argv[1] == $this->action) {
            return is_string($this->command)
                ? [$this->command, '__invoke']
                : $this->command;
        }
        return null;
    }
}