<?php

namespace is\core\console;

use is\core\BaseApp;
use is\core\shared\Arr;

class BaseCommand
{
    /** @var BaseApp */
    protected $app;

    public function __construct(BaseApp $app)
    {
        $this->app = $app;
    }

    public function line($text, $color = "\033[0m")
    {
        echo "$color$text\033[0m" . PHP_EOL;
    }

    public function error($text)
    {
        $this->line($text, "\033[31m");
    }

    public function info($text)
    {
        $this->line($text, "\033[34m");
    }

    public function success($text)
    {
        $this->line($text, "\033[32m");
    }

    public function get($key, $default = null)
    {
        return Arr::get(Input::$argv, $key, $default);
    }

    public function table(array $table)
    {
        $a = '|';
        $b = '-';
        $c = '+';

        $columnLength = [];
        foreach ($table as $row) {
            foreach (array_values($row) as $column => $value) {
                $columnLength[$column] = max($columnLength[$column] ?? 0, strlen($value));
            }
        }

        $maxWidth = array_sum($columnLength) + count($columnLength) * 3 - 1;
        echo "$c" . str_repeat("$b", $maxWidth) . "$c" . PHP_EOL;
        foreach (array_values($table) as $i => $row) {
            echo $a;
            for ($column = 0; $column < count($columnLength); $column++) {
                $value = $row[$column] ?? "";
                echo " $value" . str_repeat(" ", $columnLength[$column] - strlen($value)) . " $a";
            }
            echo PHP_EOL;
            if ($i == 0) echo "$c" . str_repeat("$b", $maxWidth) . "$c" . PHP_EOL;
        }
        echo "$c" . str_repeat("$b", $maxWidth) . "$c" . PHP_EOL;
    }
}