<?php

namespace is\core\components;

use is\core\BaseApp;
use Exception;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;

/**
 * Trait Mail
 * @package is\core\components
 *
 * @mixin BaseApp
 */
trait Mail
{
    public function bootMail()
    {
        ob_start();
    }

    public function terminateMail(): void
    {
        try {
            $mail = $this->getMailer();

            if ($mail and $this->runningInConsole()) {
                //Recipients
                $mail->addAddress('peraghi@gmail.com', 'Pooya');

                //Content
                $mail->isHTML(false);
                $mail->Subject = 'Here is the subject';
                $mail->AltBody = ob_get_flush();
                $mail->Body =
                    "<div style='font-family:monospace'>" .
                        nl2br(str_replace(' ', '&nbsp;', $mail->AltBody)) .
                    "</div>";

                $mail->send();
            }
        } catch (Exception $e) { }
    }

    public function getMailer():? PHPMailer
    {
        if (!$this->get('mail.enable')) return null;

        $mail = new PHPMailer();
        $config = $this->get('mail');

        $mail->SMTPDebug = SMTP::DEBUG_OFF;
        $mail->isSMTP();
        $mail->Host = $config['host'] ?? '';
        $mail->SMTPAuth = true;
        $mail->Username = $config['username'] ?? '';
        $mail->Password = $config['password'] ?? '';
        $mail->SMTPSecure = $config['secure'] ?? PHPMailer::ENCRYPTION_SMTPS;
        $mail->Port = $config['port'] ?? 465;
        $mail->setFrom($config['from'], $config['name']);

        return $mail;
    }
}