<?php

namespace is\core\shared;

class Arr
{
    public static function get($target, string $key = null, $default = null)
    {
        if (is_null($key)) {
            return $target;
        }

        $key = explode(".", $key);

        foreach ($key as $k => $segment) {
            unset($key[$k]);

            if ($segment == '*') {
                if (!$key) return $target;
                $temp = [];
                foreach ($target as $row) $temp[] = self::get($row, implode('.', $key));
                return array_filter($temp) ?: $default;
            }

            else if (is_array($target) and isset($target[$segment])) $target = $target[$segment];
            else if (is_object($target) and property_exists($target, $segment)) $target = $target->$segment;
            else return $default;
        }

        return $target;
    }

    public static function set(&$target, string $key, $value)
    {
        $target[$key] = $value;
        return $value;
    }
}