<?php

namespace is\core\shared;

use ArgumentCountError;

/**
 * Trait Obj
 * @package is\core\shared
 *
 * @property array $requiredArgs
 */
trait Obj
{
    public function __construct($config = [])
    {
        if (property_exists($this, 'requiredArgs')) {
            foreach ($this->requiredArgs as $property) {
                if (!isset($config[$property])) {
                    throw new ArgumentCountError(sprintf(
                        "Too few arguments to function %s::__construct(%s)",
                        static::class, $property
                    ));
                }
            }
        }

        foreach ($config as $k => $v) $this->$k = $v;
    }
}