<?php
namespace greenweb\core\i18n;

use greenweb\core\base\Transliteration;

class Persian extends Transliteration
{
    public $mapNumbers = [
        0x6f0 => [0x30, 0x660], /** ۰ */
        0x6f1 => [0x31, 0x661], /** ۱ */
        0x6f2 => [0x32, 0x662], /** ۲ */
        0x6f3 => [0x33, 0x663], /** ۳ */
        0x6f4 => [0x34, 0x664], /** ۴ */
        0x6f5 => [0x35, 0x665], /** ۵ */
        0x6f6 => [0x36, 0x666], /** ۶ */
        0x6f7 => [0x37, 0x667], /** ۷ */
        0x6f8 => [0x38, 0x668], /** ۸ */
        0x6f9 => [0x39, 0x669], /** ۹ */
    ];

    public $mapCharacters = [
           '' => [0x606, 0x607, 0x608, 0x609, 0x60a, 0x60d, 0x60e, 0x610, 0x611, 0x612, 0x613, 0x614, 0x615, 0x616, 0x618, 0x619, 0x61a, 0x61e, 0x656, 0x657, 0x658, 0x659, 0x65a, 0x65b, 0x65c, 0x65d, 0x65e, 0x65f, 0x66a, 0x66c, 0x66d, 0x6c1, 0x6c2, 0x6c3, 0x6d4, 0x6d6, 0x6d7, 0x6d8, 0x6d9, 0x6da, 0x6db, 0x6dc, 0x6de, 0x6df, 0x6e0, 0x6e1, 0x6e2, 0x6e3, 0x6e4, 0x6e5, 0x6e6, 0x6e7, 0x6e8, 0x6e9, 0x6ea, 0x6eb, 0x6ec, 0x6ed, 0x6ee, 0x6ef, 0xfba7, 0xfbb2, 0xfbb3, 0xfbb4, 0xfbb5, 0xfbb6, 0xfbb7, 0xfbb8, 0xfbb9, 0xfbba, 0xfbbb, 0xfbbc, 0xfbbd, 0xfbbe, 0xfbbf, 0xfbc0, 0xfbc1, 0xfc5e, 0xfc5f, 0xfc60, 0xfc61, 0xfc62, 0xfc63, 0xfe70, 0xfe71, 0xfe72, 0xfe73, 0xfe74, 0xfe76, 0xfe77, 0xfe78, 0xfe79, 0xfe7a, 0xfe7b, 0xfe7c, 0xfe7d, 0xfe7e, 0xfe7f],
        0x627 => [0x623, 0x625, 0x671, 0x672, 0x673, 0x675, 0x773, 0x774, 0xfb50, 0xfb51, 0xfe83, 0xfe84, 0xfe87, 0xfe88, 0xfe8d, 0xfe8e, 0x1ee80, 0xfd3c, 0xfd3d, 0x1ee00], /** ا */
        0x622 => [], /** آ */
        0x628 => [0x66e, 0x755, 0x756, 0xfb52, 0xfb53, 0xfb54, 0xfb55, 0xfe8f, 0xfe90, 0xfe91, 0xfe92, 0x1ee01, 0x1ee1c, 0x1ee21, 0x1ee61, 0x1ee7c, 0x1ee81, 0x1eea1], /** ب */
        0x67e => [0x680, 0x750, 0x754, 0xfb56, 0xfb57, 0xfb58, 0xfb59, 0xfb5a, 0xfb5b, 0xfb5c, 0xfb5d], /** پ */
        0x62a => [0x679, 0x67a, 0x67b, 0x67c, 0x753, 0xfb5e, 0xfb5f, 0xfb60, 0xfb61, 0xfb62, 0xfb63, 0xfb64, 0xfb65, 0xfb66, 0xfb67, 0xfb68, 0xfb69, 0xfe95, 0xfe96, 0xfe97, 0xfe98, 0x1ee15, 0x1ee35, 0x1ee75, 0x1ee95, 0x1eeb5], /** ت */
        0x62b => [0x67d, 0x67f, 0x751, 0xfe99, 0xfe9a, 0xfe9b, 0xfe9c, 0x1ee16, 0x1ee36, 0x1ee76, 0x1ee96, 0x1eeb6], /** ث */
        0x62c => [0x683, 0x684, 0xfb72, 0xfb73, 0xfb74, 0xfb75, 0xfb76, 0xfb77, 0xfb78, 0xfb79, 0xfe9d, 0xfe9e, 0xfe9f, 0xfea0, 0x1ee02, 0x1ee22, 0x1ee42, 0x1ee62, 0x1ee82, 0x1eea2], /** ج */
        0x686 => [0x687, 0x6bf, 0x758, 0xfb7a, 0xfb7b, 0xfb7c, 0xfb7d, 0xfb7e, 0xfb7f, 0xfb80, 0xfb81, 0x1ee03, 0x1ee83], /** چ */
        0x62d => [0x681, 0x76e, 0x76f, 0x772, 0x77c, 0xfea1, 0xfea2, 0xfea3, 0xfea4, 0x1ee07, 0x1ee27, 0x1ee47, 0x1ee67, 0x1ee87, 0x1eea7], /** ح */
        0x62e => [0x682, 0x685, 0x757, 0xfea5, 0xfea6, 0xfea7, 0xfea8, 0x1ee17, 0x1ee37, 0x1ee57, 0x1ee77, 0x1ee97, 0x1eeb7], /** خ */
        0x62f => [0x688, 0x689, 0x68a, 0x68c, 0x68d, 0x68e, 0x68f, 0x690, 0x759, 0x75a, 0xfea9, 0xfeaa, 0x1eea3, 0xfb82, 0xfb83, 0xfb88, 0xfb89], /** د */
        0x630 => [0xfc5b, 0xfc5d, 0xfeab, 0xfeac, 0x1ee18, 0x1ee98, 0x1eeb8, 0xfb84, 0xfb85, 0xfb86, 0xfb87], /** ذ */
        0x631 => [0x66b, 0x691, 0x692, 0x693, 0x694, 0x695, 0x696, 0x75b, 0x76c, 0xfb8c, 0xfb8d, 0xfc5c, 0xfead, 0xfeae, 0x1ee13, 0x1ee93, 0x1eeb3], /** ر */
        0x632 => [0x697, 0x699, 0x76b, 0x771, 0xfeaf, 0xfeb0, 0x1ee06, 0x1ee86, 0x1eea6], /** ز */
        0x698 => [0xfb8a, 0xfb8b, 0x698], /** ژ */
        0x633 => [0x69a, 0x77d, 0x77e, 0xfeb1, 0xfeb2, 0xfeb3, 0xfeb4, 0x1ee0e, 0x1ee2e, 0x1ee4e, 0x1ee6e, 0x1ee8e, 0x1eeae], /** س */
        0x634 => [0x69b, 0x6fa, 0x75c, 0x76d, 0x770, 0xfeb5, 0xfeb6, 0xfeb7, 0xfeb8, 0x1ee14, 0x1ee34, 0x1ee54, 0x1ee74, 0x1ee94, 0x1eeb4], /** ش */
        0x635 => [0x69d, 0xfeb9, 0xfeba, 0xfebb, 0xfebc, 0x1ee11, 0x1ee51, 0x1ee31, 0x1ee71, 0x1ee91, 0x1eeb1], /** ص */
        0x636 => [0x69e, 0x6fb, 0xfebd, 0xfebe, 0xfebf, 0xfec0, 0x1ee19, 0x1ee39, 0x1ee59, 0x1ee79, 0x1ee99, 0x1eeb9], /** ض */
        0x637 => [0xfec1, 0xfec2, 0xfec3, 0xfec4, 0x1ee08, 0x1ee68, 0x1ee88, 0x1eea8], /** ط */
        0x638 => [0x69f, 0xfec5, 0xfec6, 0xfec7, 0xfec8, 0x1ee1a, 0x1ee7a, 0x1ee9a, 0x1eeba], /** ظ */
        0x639 => [0x60f, 0x6a0, 0xfec9, 0xfeca, 0xfecb, 0xfecc, 0x1ee0f, 0x1ee2f, 0x1ee4f, 0x1ee6f, 0x1ee8f, 0x1eeaf], /** ع */
        0x63a => [0x6fc, 0x75d, 0x75e, 0x75f, 0xfecd, 0xfece, 0xfecf, 0xfed0, 0x1ee1b, 0x1ee3b, 0x1ee5b, 0x1ee7b, 0x1ee9b, 0x1eebb], /** غ */
        0x641 => [0x60b, 0x6a1, 0x6a2, 0x6a3, 0x6a4, 0x6a5, 0x6a6, 0x760, 0x761, 0xfb6a, 0xfb6b, 0xfb6c, 0xfb6d, 0xfb6e, 0xfb6f, 0xfb70, 0xfb71, 0xfed1, 0xfed2, 0xfed3, 0xfed4, 0x1ee10, 0x1ee1e, 0x1ee30, 0x1ee70, 0x1ee7e, 0x1ee90, 0x1eeb0], /** ف */
        0x642 => [0x66f, 0x6a7, 0x6a8, 0xfed5, 0xfed6, 0xfed7, 0xfed8, 0x1ee12, 0x1ee1f, 0x1ee32, 0x1ee52, 0x1ee5f, 0x1ee72, 0x1ee92, 0x1eeb2, 0x608], /** ق */
        0x6a9 => [0x63b, 0x63c, 0x643, 0x6aa, 0x6ab, 0x6ac, 0x6ad, 0x6ae, 0x762, 0x763, 0x764, 0x77f, 0xfb8e, 0xfb8f, 0xfb90, 0xfb91, 0xfbd3, 0xfbd4, 0xfbd5, 0xfbd6, 0xfed9, 0xfeda, 0xfedb, 0xfedc, 0x1ee0a, 0x1ee2a, 0x1ee6a], /** ک */
        0x6af => [0x6b0, 0x6b1, 0x6b2, 0x6b3, 0x6b4, 0xfb92, 0xfb93, 0xfb94, 0xfb95, 0xfb96, 0xfb97, 0xfb98, 0xfb99, 0xfb9a, 0xfb9b, 0xfb9c, 0xfb9d], /** گ */
        0x644 => [0x6b5, 0x6b6, 0x6b7, 0x6b8, 0x76a, 0xfedd, 0xfede, 0xfedf, 0xfee0, 0x1ee0b, 0x1ee2b, 0x1ee4b, 0x1ee8b, 0x1eeab], /** ل */
        0x645 => [0x6fe, 0x765, 0x766, 0xfee1, 0xfee2, 0xfee3, 0xfee4, 0x1ee0c, 0x1ee2c, 0x1ee6c, 0x1ee8c, 0x1eeac], /** م */
        0x646 => [0x6b9, 0x6ba, 0x6bb, 0x6bc, 0x6bd, 0x767, 0x768, 0x769, 0xfb9e, 0xfb9f, 0xfba0, 0xfba1, 0xfee5, 0xfee6, 0xfee7, 0xfee8, 0x1ee0d, 0x1ee1d, 0x1ee2d, 0x1ee4d, 0x1ee5d, 0x1ee6d, 0x1ee8d, 0x1eead], /** ن */
        0x648 => [0x624, 0x676, 0x677, 0x6c4, 0x6c5, 0x6c6, 0x6c7, 0x6c8, 0x6c9, 0x6ca, 0x6cb, 0x6cf, 0x778, 0x779, 0xfbd7, 0xfbd8, 0xfbd9, 0xfbda, 0xfbdb, 0xfbdc, 0xfbdd, 0xfbde, 0xfbdf, 0xfbe0, 0xfbe1, 0xfbe2, 0xfbe3, 0xfe85, 0xfe86, 0xfeed, 0xfeee, 0x1ee05, 0x1ee85, 0x1eea5], /** و */
        0x647 => [0x629, 0x6be, 0x6c0, 0x6d5, 0x6ff, 0xfba4, 0xfba5, 0xfba6, 0xfba9, 0xfba8, 0xfbaa, 0xfbab, 0xfbac, 0xfbad, 0xfe93, 0xfe94, 0xfee9, 0xfeea, 0xfeeb, 0xfeec, 0x1ee24, 0x1ee64, 0x1ee84], /** ه */
        0x6cc => [0x620, 0x626, 0x63d, 0x63e, 0x63f, 0x649, 0x64a, 0x678, 0x6cd, 0x6ce, 0x6d0, 0x6d1, 0x6d2, 0x6d3, 0x775, 0x776, 0x777, 0x77a, 0x77b, 0xfba2, 0xfba3, 0xfbae, 0xfbaf, 0xfbb0, 0xfbb1, 0xfbe4, 0xfbe5, 0xfbe6, 0xfbe7, 0xfbe8, 0xfbe9, 0xfbfc, 0xfbfd, 0xfbfe, 0xfbff, 0xfe89, 0xfe8a, 0xfe8b, 0xfe8c, 0xfeef, 0xfef0, 0xfef1, 0xfef2, 0xfef3, 0xfef4, 0x1ee09, 0x1ee29, 0x1ee49, 0x1ee69, 0x1ee89, 0x1eea9], /** ی */
        0x621 => [0x674, 0x6fd, 0xfe80], /** ء */
    ];

    public $mapWords = [
        [[0x644, 0x627], [0xfef5, 0xfef6, 0xfef7, 0xfef8, 0xfef9, 0xfefa, 0xfefb, 0xfefc]], /** لا */
        [[0x627, 0x644, 0x644, 0x647], [0xfdf2]], /** الله */
        [[0x631, 0x6cc, 0x627, 0x644], [0xfdfc]], /** ريال */
        [[0x627, 0x6a9, 0x628, 0x631], [0xfdf3]], /** اکبر */
        [[0x645, 0x62d, 0x645, 0x62f], [0xfdf4]], /** محمد */
        [[0x635, 0x644, 0x639, 0x645], [0xfdf5]], /** صلعم */
        [[0x631, 0x633, 0x648, 0x644], [0xfdf6]], /** رسول */
        [[0x639, 0x644, 0x6cc, 0x647], [0xfdf7]], /** عليه */
        [[0x648, 0x633, 0x644, 0x645], [0xfdf8]], /** وسلم */
        [[0x635, 0x644, 0x6cc], [0xfdf9]], /** صلي */
        [[0x635, 0x644, 0x6cc, 0x20, 0x627, 0x644, 0x644, 0x647, 0x20, 0x639, 0x644, 0x6cc, 0x647, 0x20, 0x648, 0x633, 0x644, 0x645], [0xfdfa]], /** صلي الله عليه وسلم */
        [[0x62c, 0x644, 0x20, 0x62c, 0x644, 0x627, 0x644, 0x647], [0xfdfb]] /** جل جلاله */
    ];

    public function isValid($text)
    {
        /** Check all chars and numbers of persian alphabet. */
        return preg_match_all('/^[\x{6f0}\x{6f1}\x{6f2}\x{6f3}\x{6f4}\x{6f5}\x{6f6}\x{6f7}\x{6f8}\x{6f9}\s\x{627}\x{622}\x{628}\x{67e}\x{62a}\x{62b}\x{62c}\x{686}\x{62d}\x{62e}\x{62f}\x{630}\x{631}\x{632}\x{698}\x{633}\x{634}\x{635}\x{636}\x{637}\x{638}\x{639}\x{63a}\x{641}\x{642}\x{6a9}\x{6af}\x{644}\x{645}\x{646}\x{648}\x{647}\x{6cc}\x{621}]*$/u', $text);
    }
}