<?php
namespace greenweb\core\helpers;

class Helper
{
    public static function microTime()
    {
        list($uSec, $sec) = explode(" ", microtime());
        return ((float)$uSec + (float)$sec);
    }

    public static function getPublicProperties($object)
    {
        $obj = new \ReflectionClass($object);
        $public = array_map(function($o){ return $o->name; }, $obj->getProperties(\ReflectionProperty::IS_PUBLIC));
        $static = array_map(function($o){ return $o->name; }, $obj->getProperties(\ReflectionProperty::IS_STATIC));
        return array_diff($public, $static);
    }

    /**
     * @param string $ip With v4 structure.
     * @param string $date This param is use for finding related ip database file.
     * @return string ISO two char country name.
     * @see http://lite.ip2location.com/database/ip-country for updating ip database.
     */
    public static function ip2Location($ip, $date = null)
    {
        $ds = DIRECTORY_SEPARATOR;
        $dir = dirname(__DIR__) . "{$ds}assets{$ds}ips";
        $files = scandir($dir, SORT_DESC);
        $isIpv6 = (strpos($ip, ':') !== false);

        $binNum = '';
        foreach (unpack('C*', inet_pton($ip)) as $byte) {
            $binNum .= str_pad(decbin($byte), 8, "0", STR_PAD_LEFT);
        }
        $ip = base_convert(ltrim($binNum, '0'), 2, 10);

        if ($date !== null) {
            foreach($files as $file) {
                if(strncmp($isIpv6 ? 'ipv6-': 'ipv4-', $file, 5) === 0 and strtotime($date) >= strtotime(substr($file, 5, 10))) {
                    $fileName = $dir . $ds . $file;
                    break;
                }
            }
        }

        if (!isset($fileName)) $fileName = $dir . $ds . reset($files);

        if($fp = fopen($fileName, 'r')) {
            while( !feof($fp) ) {
                $line = fgetcsv($fp);
                if( $ip >= $line[0] and $ip <= $line[1] ) {
                    return strtolower($line[2]);
                }
            }
        }

        return '-';
    }
}