<?php
namespace greenweb\core\drawing;

use greenweb\core\base\PrimaryObject;
use greenweb\core\helpers\ArrayHelper;

class Table extends PrimaryObject
{
    /**
     * @var Canvas
     */
    public $img;

    /**
     * @var Style|array
     */
    public $style = [];
    
    /**
     * @var array rows configs.
     */
    public $rows = [];

    /**
     * @var array configs for each specify rows.
     */
    public $xRows = [];
    
    public $data = [];
    
    public function init()
    {
        $this->style = new Style(ArrayHelper::merge($this->defaultStyle(), $this->style, ['img' => $this->img]));
    }

    public function render()
    {
        $img = $this->img;
        $style = $this->style;
        
        $rowX = $style->x + $style->paddingStart + $style->borderWidth;
        $rowY = $style->y + $style->paddingTop + $style->borderWidth;
        
        foreach ($this->data as $index => $rowData) {
            $row = new Row(ArrayHelper::merge($this->rows, isset($this->xRows[$index]) ? $this->xRows[$index] : [], [
                'table' => $this,
                'index' => $index,
                'data' => $rowData  
            ]));
            $row->style->x = $rowX;
            $row->style->y = $rowY;
            $row->render();
            $rowY += $row->style->height;
        }

        $tableHeight = ($rowY - $style->y) + $style->paddingBottom + $style->borderWidth;
        if ($style->height === null) {
            $style->height = $tableHeight;
        } else {
            $style->height = $style->height > $tableHeight ? $style->height : $tableHeight;
        }
        
        /** TODO: find a way to render rows after this. */
        //$img->rectangle($style->x, $style->y, $style->width, $style->height, $style->backgroundColor);
        $img->rectangle($style->x, $style->y, $style->width, $style->height, $style->borderColor, false);
    }
    
    public function defaultStyle()
    {
        return [
            'paddingTop' => 2,
            'paddingStart' => 2,
            'paddingBottom' => 2,
            'paddingEnd' => 2,
            'x' => 0,
            'y' => 0,
            'width' => '100%', /** Note: do not set null. not sure what happen :D */
            'height' => null, /** If null determine from rows height. otherwise value must greater than rows height. */
            'fontFamily' => '',
            'fontSize' => 12,
            'color' => [0, 0, 0],
            'backgroundColor' => [255, 255, 255],
            'borderColor' => [0, 0, 0],
            'borderWidth' => 1
        ];
    }
}