<?php
namespace greenweb\core\drawing;

use greenweb\core\base\PrimaryObject;
use greenweb\core\helpers\ArrayHelper;

class Row extends PrimaryObject
{
    /**
     * @var Table
     */
    public $table;

    public $index;

    /**
     * @var Style|array
     */
    public $style = [];

    /**
     * @var array cells configs.
     */
    public $cells = [];

    /**
     * @var array configs for each specify cells.
     */
    public $xCells = [];
    
    public $data = [];
    
    public function inheritStyle()
    {
        return ['fontFamily', 'fontSize', 'color', 'backgroundColor', 'borderColor'];
    }
    
    public function init()
    {
        $img = $this->table->img;
        $parentStyle = array_intersect_key(get_object_vars($this->table->style), array_flip($this->inheritStyle()));
        $this->style = new Style(ArrayHelper::merge($this->defaultStyle(), $parentStyle, $this->style, ['img' => $img]));
    }

    public function render()
    {
        $cells = [];
        $img = $this->table->img;
        $style = $this->style;
        $tblStyle = $this->table->style;

        $style->width = $tblStyle->width - $tblStyle->paddingStart - $tblStyle->paddingEnd - (2 * $tblStyle->borderWidth);
        $style->height = 0;
        
        $cellX = $style->x + $style->paddingStart;
        $cellY = $style->y + $style->paddingTop;
        $highestCell = 0;

        /** @var Cell[] $cells */
        foreach ($this->data as $index => $cellData) {
            $cell = $cells[$index] = new Cell(ArrayHelper::merge($this->cells, isset($this->xCells[$index]) ? $this->xCells[$index] : [], [
                'row' => $this,
                'index' => $index,
                'data' => $cellData
            ]));
            $highestCell = $cell->suggestedHeight > $highestCell ? $cell->suggestedHeight : $highestCell;
        }
        
        foreach ($cells as $index => $cell) {
            $cell->style->x = $cellX;
            $cell->style->y = $cellY;
            $cell->suggestedWidth = (mb_strlen($cell->data) / mb_strlen(implode('', $this->data))) * $style->width;
            $cell->style->height = $highestCell;
            $cell->render();
            $cellX += $cell->style->width;
            $style->height = $cell->style->height > $style->height ? $cell->style->height + $style->paddingTop + $style->paddingBottom : $style->height;
        }

        /** TODO: find a way to render cells after this. */
        //$img->rectangle($style->x, $style->y, $style->width, $style->height, $style->backgroundColor);
        $img->rectangle($style->x, $style->y, $style->width, $style->height, $style->borderColor, false);
    }

    public function defaultStyle()
    {
        return [
            'paddingTop' => 0,
            'paddingStart' => 0,
            'paddingBottom' => 0,
            'paddingEnd' => 0,
            'x' => 0, /** Determine from table position. */
            'y' => 0, /** Determine from table position. */
            'width' => '100%', /** Static 100%. */
            'height' => null, /** determine from cells biggest height. */
            'fontFamily' => '',
            'fontSize' => 12,
            'color' => [0, 0, 0],
            'backgroundColor' => [255, 255, 255],
            'borderColor' => [0, 0, 0],
            'borderWidth' => 1
        ];
    }
}