<?php
namespace greenweb\core\drawing;

use greenweb\core\base\PrimaryObject;
use greenweb\core\helpers\ArrayHelper;

class Cell extends PrimaryObject
{
    /**
     * @var Row
     */
    public $row;
    
    public $index;

    /**
     * @var Style|array
     */
    public $style = [];
    
    public $data;

    public $suggestedWidth;

    public $suggestedHeight;

    public function inheritStyle()
    {
        return $this->row->inheritStyle();
    }

    public function init()
    {
        $img = $this->row->table->img;
        $parentStyle = array_intersect_key(get_object_vars($this->row->style), array_flip($this->inheritStyle()));
        $this->style = new Style(ArrayHelper::merge($this->defaultStyle(), $parentStyle, $this->style, ['img' => $img]));

        list(,$h) = $img->prepareText($this->style->fontSize, 0, $this->style->fontFamily, str_replace(PHP_EOL, '', $this->data));
        $this->suggestedHeight = $this->getLinesCount() * ($h * 1.5) + $this->style->paddingTop + $this->style->paddingBottom;
    }

    public function render()
    {
        $img = $this->row->table->img;
        $style = $this->style;

        if ($style->width === null) {
            $style->width = $this->suggestedWidth;
        }

        if($style->width + $style->x > $this->row->style->width + $this->row->style->x) {
            $style->width = $this->row->style->width + $this->row->style->x - $style->x;
        }

        $img->rectangle($style->x, $style->y, $style->width, $style->height, $style->backgroundColor);
        $img->rectangle($style->x, $style->y, $style->width, $style->height, $style->borderColor, false);
        $this->insertData();
    }

    public function getLinesCount()
    {
        return substr_count($this->data, PHP_EOL) + 1;
    }

    public function insertData()
    {
        $img = $this->row->table->img;
        $style = $this->style;
        $lNo = 1;
        foreach (explode(PHP_EOL, $this->data) as $line) {
            $x = ($lNo / ($this->getLinesCount() + 1));
            $img->text($line, $style->fontSize, $style->x + $style->paddingStart, $style->y + $style->paddingTop + ($style->height * $x), $style->fontFamily, $style->color);
            $lNo++;
        }
    }

    public function defaultStyle()
    {
        return [
            'paddingTop' => 4,
            'paddingStart' => 4,
            'paddingBottom' => 4,
            'paddingEnd' => 4,
            'x' => 0, /** Determine from row position. */
            'y' => 0, /** Determine from row position. */
            'width' => null, /** If null, determine by data. */
            'height' => null, /** Determine by row. */
            'fontFamily' => '',
            'fontSize' => 12,
            'color' => [0, 0, 0],
            'backgroundColor' => [255, 255, 255],
            'borderColor' => [0, 0, 0],
            'borderWidth' => 1
        ];
    }
}