<?php
namespace greenweb\core\commands;

use greenweb\core\base\PrimaryObject;
use greenweb\core\interfaces\CommandInterface;

class ExtractGZip extends PrimaryObject implements CommandInterface
{
    public $bufferSize = 4096;

    public $fileName;

    public $extractFileName;

    public $deleteGZip = true;

    public function init()
    {
        if($this->extractFileName === null) {
            $pos = strrpos($this->fileName, '.');
            $this->extractFileName = substr($this->fileName, 0, $pos);
        }
    }

    public function execute()
    {
        try {
            $file = gzopen($this->fileName, 'rb');
            $out_file = fopen($this->extractFileName, 'wb');
            while (!gzeof($file)) {
                fwrite($out_file, gzread($file, $this->bufferSize));
            }
            fclose($out_file);
            gzclose($file);

            if ($this->deleteGZip) {
                @unlink($this->fileName);
            }
            return true;
        } catch (\Exception $ex) {
            return false;
        }
    }
}