<?php
namespace greenweb\core\browser;

use greenweb\core\base\PrimaryObject;

class Browser extends PrimaryObject
{
    private $ch;

    /**
     * @var bool Set true if you want to simulate browser requests.
     */
    public $cookies = true;

    public $followLocation = true;

    public $autoReferrer = true;

    public $options = [];

    public $dir;

    public function init()
    {
        if ($this->dir === null) {
            $this->dir = __DIR__;
        }

        $this->ch = curl_init();

        $this->setOptions([
            CURLOPT_HEADER => true,
            CURLOPT_RETURNTRANSFER => true
        ]);

        foreach ($this->options as $key => $value) {
            curl_setopt($this->ch, $key, $value);
        }

        if ($this->cookies) {
            $this->setOptions([
                CURLOPT_COOKIESESSION => true,
                CURLOPT_COOKIEFILE => $this->dir . '/cookie.file',
                CURLOPT_COOKIEJAR => $this->dir . '/cookie.jar'
            ]);
        }

        $this->setOptions([
            CURLOPT_FOLLOWLOCATION => $this->followLocation,
            CURLOPT_AUTOREFERER => $this->autoReferrer
        ]);
    }

    public function setOptions(array $options)
    {
        foreach ($options as $key => $value) {
            $this->options[$key] = $value;
            curl_setopt($this->ch, $key, $value);
        }
    }

    public function post($url, array $data = [])
    {
        $this->setOptions([
            CURLOPT_URL => $url,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => count($data) ? http_build_query($data) : '',
            CURLOPT_REFERER => $this->autoReferrer ? $url : ''
        ]);

        $result = curl_exec($this->ch);
        $info = curl_getinfo($this->ch);
        $response = new Response();
        $response->setResponse($result, $info);
        return $response;
    }

    public function get($url, array $data = [])
    {
        $this->setOptions([
            CURLOPT_URL => $url,
            CURLOPT_POSTFIELDS => '',
            CURLOPT_HTTPGET => true,
            CURLOPT_REFERER => $this->autoReferrer ? $url : ''
        ]);

        $result = curl_exec($this->ch);
        $info = curl_getinfo($this->ch);
        $response = new Response();
        $response->setResponse($result, $info);
        return $response;
    }
}