<?php
namespace greenweb\core\base;

use greenweb\core\App;
use greenweb\core\interfaces\CommandInterface;

abstract class Download extends PrimaryObject
{
    public $fileName;

    public $autoName = true;

    /**
     * @var CommandInterface[]
     */
    public $commands = [];

    public function init()
    {
        if($this->autoName) {
            $this->fileName = rtrim($this->fileName, '/\\') . '/' . $this->remoteFileName();
        }

        foreach($this->commands as $key => $class) {
            $obj = App::createObject($class);
            if(!$obj instanceof CommandInterface) {
                throw new \Exception("Commands must be instance of command interface.");
            }
            $this->commands[$key] = $obj;
        }
    }

    public function get()
    {
        $result = $this->download();
        foreach($this->commands as $obj) {
            $result = ($result and $obj->execute());
        }
        return $result;
    }

    abstract public function download();

    abstract public function remoteFileName();
}