<?php
namespace Illuminate\Console\Scheduling;
class Event  {
    public $command;
    public $expression;
    public $timezone;
    public $user;
    public $environments;
    public $evenInMaintenanceMode;
    public $withoutOverlapping;
    public $runInBackground;
    protected $filters;
    protected $rejects;
    public $output;
    protected $shouldAppendOutput;
    protected $beforeCallbacks;
    protected $afterCallbacks;
    public $description;
    /**
     * Create a new event instance.
     *
     * @param  string  $command
     * @return void
     */
    public function __construct($command) {}
    /**
     * Get the default output depending on the OS.
     *
     * @return string
     */
    protected function getDefaultOutput() {}
    /**
     * Run the given event.
     *
     * @param  \Illuminate\Contracts\Container\Container  $container
     * @return void
     */
    public function run($container) {}
    /**
     * Run the command in the foreground.
     *
     * @param  \Illuminate\Contracts\Container\Container  $container
     * @return void
     */
    protected function runCommandInForeground($container) {}
    /**
     * Run the command in the background.
     *
     * @return void
     */
    protected function runCommandInBackground() {}
    /**
     * Call all of the "before" callbacks for the event.
     *
     * @param  \Illuminate\Contracts\Container\Container  $container
     * @return void
     */
    protected function callBeforeCallbacks($container) {}
    /**
     * Call all of the "after" callbacks for the event.
     *
     * @param  \Illuminate\Contracts\Container\Container  $container
     * @return void
     */
    protected function callAfterCallbacks($container) {}
    /**
     * Build the command string.
     *
     * @return string
     */
    public function buildCommand() {}
    /**
     * Get the mutex path for the scheduled command.
     *
     * @return string
     */
    protected function mutexPath() {}
    /**
     * Determine if the given event should run based on the Cron expression.
     *
     * @param  \Illuminate\Contracts\Foundation\Application  $app
     * @return bool
     */
    public function isDue($app) {}
    /**
     * Determine if the Cron expression passes.
     *
     * @return bool
     */
    protected function expressionPasses() {}
    /**
     * Determine if the filters pass for the event.
     *
     * @param  \Illuminate\Contracts\Foundation\Application  $app
     * @return bool
     */
    public function filtersPass($app) {}
    /**
     * Determine if the event runs in the given environment.
     *
     * @param  string  $environment
     * @return bool
     */
    public function runsInEnvironment($environment) {}
    /**
     * Determine if the event runs in maintenance mode.
     *
     * @return bool
     */
    public function runsInMaintenanceMode() {}
    /**
     * The Cron expression representing the event's frequency.
     *
     * @param  string  $expression
     * @return $this
     */
    public function cron($expression) {}
    /**
     * Schedule the event to run hourly.
     *
     * @return $this
     */
    public function hourly() {}
    /**
     * Schedule the event to run daily.
     *
     * @return $this
     */
    public function daily() {}
    /**
     * Schedule the command at a given time.
     *
     * @param  string  $time
     * @return $this
     */
    public function at($time) {}
    /**
     * Schedule the event to run daily at a given time (10:00, 19:30, etc).
     *
     * @param  string  $time
     * @return $this
     */
    public function dailyAt($time) {}
    /**
     * Schedule the event to run twice daily.
     *
     * @param  int  $first
     * @param  int  $second
     * @return $this
     */
    public function twiceDaily($first = 1, $second = 13) {}
    /**
     * Schedule the event to run only on weekdays.
     *
     * @return $this
     */
    public function weekdays() {}
    /**
     * Schedule the event to run only on Mondays.
     *
     * @return $this
     */
    public function mondays() {}
    /**
     * Schedule the event to run only on Tuesdays.
     *
     * @return $this
     */
    public function tuesdays() {}
    /**
     * Schedule the event to run only on Wednesdays.
     *
     * @return $this
     */
    public function wednesdays() {}
    /**
     * Schedule the event to run only on Thursdays.
     *
     * @return $this
     */
    public function thursdays() {}
    /**
     * Schedule the event to run only on Fridays.
     *
     * @return $this
     */
    public function fridays() {}
    /**
     * Schedule the event to run only on Saturdays.
     *
     * @return $this
     */
    public function saturdays() {}
    /**
     * Schedule the event to run only on Sundays.
     *
     * @return $this
     */
    public function sundays() {}
    /**
     * Schedule the event to run weekly.
     *
     * @return $this
     */
    public function weekly() {}
    /**
     * Schedule the event to run weekly on a given day and time.
     *
     * @param  int  $day
     * @param  string  $time
     * @return $this
     */
    public function weeklyOn($day, $time = '0:0') {}
    /**
     * Schedule the event to run monthly.
     *
     * @return $this
     */
    public function monthly() {}
    /**
     * Schedule the event to run monthly on a given day and time.
     *
     * @param int  $day
     * @param string  $time
     * @return $this
     */
    public function monthlyOn($day = 1, $time = '0:0') {}
    /**
     * Schedule the event to run quarterly.
     *
     * @return $this
     */
    public function quarterly() {}
    /**
     * Schedule the event to run yearly.
     *
     * @return $this
     */
    public function yearly() {}
    /**
     * Schedule the event to run every minute.
     *
     * @return $this
     */
    public function everyMinute() {}
    /**
     * Schedule the event to run every five minutes.
     *
     * @return $this
     */
    public function everyFiveMinutes() {}
    /**
     * Schedule the event to run every ten minutes.
     *
     * @return $this
     */
    public function everyTenMinutes() {}
    /**
     * Schedule the event to run every thirty minutes.
     *
     * @return $this
     */
    public function everyThirtyMinutes() {}
    /**
     * Set the days of the week the command should run on.
     *
     * @param  array|mixed  $days
     * @return $this
     */
    public function days($days) {}
    /**
     * State that the command should run in background.
     *
     * @return $this
     */
    public function runInBackground() {}
    /**
     * Set the timezone the date should be evaluated on.
     *
     * @param  \DateTimeZone|string  $timezone
     * @return $this
     */
    public function timezone($timezone) {}
    /**
     * Set which user the command should run as.
     *
     * @param  string  $user
     * @return $this
     */
    public function user($user) {}
    /**
     * Limit the environments the command should run in.
     *
     * @param  array|mixed  $environments
     * @return $this
     */
    public function environments($environments) {}
    /**
     * State that the command should run even in maintenance mode.
     *
     * @return $this
     */
    public function evenInMaintenanceMode() {}
    /**
     * Do not allow the event to overlap each other.
     *
     * @return $this
     */
    public function withoutOverlapping() {}
    /**
     * Register a callback to further filter the schedule.
     *
     * @param  \Closure  $callback
     * @return $this
     */
    public function when($callback) {}
    /**
     * Register a callback to further filter the schedule.
     *
     * @param  \Closure  $callback
     * @return $this
     */
    public function skip($callback) {}
    /**
     * Send the output of the command to a given location.
     *
     * @param  string  $location
     * @param  bool  $append
     * @return $this
     */
    public function sendOutputTo($location, $append = false) {}
    /**
     * Append the output of the command to a given location.
     *
     * @param  string  $location
     * @return $this
     */
    public function appendOutputTo($location) {}
    /**
     * E-mail the results of the scheduled operation.
     *
     * @param  array|mixed  $addresses
     * @param  bool  $onlyIfOutputExists
     * @return $this
     *
     * @throws \LogicException
     */
    public function emailOutputTo($addresses, $onlyIfOutputExists = false) {}
    /**
     * E-mail the results of the scheduled operation if it produces output.
     *
     * @param  array|mixed  $addresses
     * @return $this
     *
     * @throws \LogicException
     */
    public function emailWrittenOutputTo($addresses) {}
    /**
     * E-mail the output of the event to the recipients.
     *
     * @param  \Illuminate\Contracts\Mail\Mailer  $mailer
     * @param  array  $addresses
     * @param  bool  $onlyIfOutputExists
     * @return void
     */
    protected function emailOutput($mailer, $addresses, $onlyIfOutputExists = false) {}
    /**
     * Get the e-mail subject line for output results.
     *
     * @return string
     */
    protected function getEmailSubject() {}
    /**
     * Register a callback to ping a given URL before the job runs.
     *
     * @param  string  $url
     * @return $this
     */
    public function pingBefore($url) {}
    /**
     * Register a callback to be called before the operation.
     *
     * @param  \Closure  $callback
     * @return $this
     */
    public function before($callback) {}
    /**
     * Register a callback to ping a given URL after the job runs.
     *
     * @param  string  $url
     * @return $this
     */
    public function thenPing($url) {}
    /**
     * Register a callback to be called after the operation.
     *
     * @param  \Closure  $callback
     * @return $this
     */
    public function after($callback) {}
    /**
     * Register a callback to be called after the operation.
     *
     * @param  \Closure  $callback
     * @return $this
     */
    public function then($callback) {}
    /**
     * Set the human-friendly description of the event.
     *
     * @param  string  $description
     * @return $this
     */
    public function name($description) {}
    /**
     * Set the human-friendly description of the event.
     *
     * @param  string  $description
     * @return $this
     */
    public function description($description) {}
    /**
     * Splice the given value into the given position of the expression.
     *
     * @param  int  $position
     * @param  string  $value
     * @return $this
     */
    protected function spliceIntoPosition($position, $value) {}
    /**
     * Get the summary of the event for display.
     *
     * @return string
     */
    public function getSummaryForDisplay() {}
    /**
     * Get the Cron expression for the event.
     *
     * @return string
     */
    public function getExpression() {}
}