<?php
namespace greenweb\core\whmcs;

use greenweb\core\models\KVPModel;
use Illuminate\Database\Capsule\Manager as Capsule;

class Setting extends KVPModel
{
    private $configuration;

    public function configuration()
    {
        if ($this->configuration === null) {
            $this->configuration = Capsule::table(static::whmcsConfigurationTableName())->pluck('value', 'setting');
            return $this->configuration;
        }

        return $this->configuration;
    }

    public function saveConfiguration(array $data)
    {
        foreach ($data as $setting => $value) {
            $this->configuration[$setting] = $value;
            Capsule::table(static::whmcsConfigurationTableName())->where('setting', '=', $setting)->update(['value' => $value]);
        }
    }

    /**
     * @throws \Exception if not override this method.
     * @return string Table name.
     */
    public static function whmcsConfigurationTableName()
    {
        throw new \Exception("Whmcs configuration table name is not declared.");
    }
}