<?php
namespace greenweb\core\whmcs;

use greenweb\core\base\PrimaryObject;
use ReflectionClass;
use Exception;
use ReflectionMethod;

class Prototyper extends PrimaryObject
{
    public $classes = [
        'WHMCS\Terminus',
        'WHMCS\Exception\Fatal',
        'WHMCS\Cron',
        'WHMCS_ClientArea',
        'WHMCS\Announcement\Announcement',
        'WHMCS\Billing\Invoice\Item',
        'WHMCS\Billing\Payment\Transaction',
        'WHMCS\Billing\Quote\Item',
        'WHMCS\Billing\Invoice',
        'WHMCS\Billing\Quote',
        'WHMCS\Config\Setting',
        'WHMCS\Domain\AdditionalField',
        'WHMCS\Domain\Domain',
        'WHMCS\Domain\Extra',
        'WHMCS\Domains\DomainLookup\ResultsList',
        'WHMCS\Domains\DomainLookup\SearchResult',
        'WHMCS\Domains\Pricing\Premium',
        'WHMCS\Download\Category',
        'WHMCS\Download\Download',
        'WHMCS\Log\Register',
        'WHMCS\Mail\Template',
        'WHMCS\Module\AbstractWidget',
        'WHMCS\Module\Queue',
        'WHMCS\Network\NetworkIssue',
        'WHMCS\Product\Group',
        'WHMCS\Product\Product',
        'WHMCS\Scheduling\Task\AbstractTask',
        'WHMCS\Service\Addon',
        'WHMCS\Service\CancellationRequest',
        'WHMCS\Service\Service',
        'WHMCS\User\Client\Affiliate',
        'WHMCS\User\Client\Contact',
        'WHMCS\User\Client\SecurityQuestion',
        'WHMCS\User\Admin',
        'WHMCS\User\AdminLog',
        'WHMCS\User\Alert',
        'WHMCS\User\Client',
        'WHMCS\View\Formatter\Price',
        'WHMCS\View\Menu\Item',
        'WHMCS\CustomField',
        'WHMCS\Config\Application',
        'WHMCS\License',
        'WHMCS\Application',
        'WHMCS\View\Template',
        'WHMCS\Config\Template',
        'WHMCS\Order\Order'
    ];

    public $createdClasses = [];

    public function run()
    {
        $this->walkOnClasses(function($rClass, $parent, $traits) {
            /** @var ReflectionClass $rClass */
            /** @var string $parent */
            /** @var string[] $traits */
            $p = strrpos($rClass->name, '\\');
            $ns = substr($rClass->name, 0, $p !== false ? $p : 0);
            $traitsStr = $traits ? ("    use \\" . implode(";" . PHP_EOL . "    use \\", $traits) . ";" . PHP_EOL) : "";
            $out = $this->template([
                '{classType}' => $rClass->isTrait() ? 'trait' : ($rClass->isAbstract() ? 'abstract class' : 'class'),
                '{namespace}' => $ns ? "namespace $ns;" : '',
                    '{class}' => substr($rClass->name, $p !== false ? $p + 1 : 0),
                     '{data}' => trim($traitsStr . $this->getProperties($rClass) . $this->getMethods($rClass)),
                  '{extends}' => $parent ? "extends \\$parent" : ''
            ]);

            @mkdir(__DIR__ . "/_whmcs_core");
            file_put_contents(__DIR__ . "/_whmcs_core/" . str_replace(["\\", "//"], "-", $rClass->name) . ".php", $out);
        });
    }

    public function template(array $params = [])
    {
        $ret =
        "<?php"                                . PHP_EOL .
        "{namespace}"                          . PHP_EOL .
        "{classType} {class} {extends} {"            . PHP_EOL .
        "    {data}"                           . PHP_EOL .
        "}";
        return strtr($ret, $params);
    }

    /**
     * @param ReflectionClass $rClass
     * @return string
     */
    public function getProperties($rClass)
    {
        $out = "";
        $D = '$';
        foreach ($rClass->getProperties() as $prop) {
            if ($rClass->name !== $prop->class) {
                continue;
            }
            $out .= "    ";

            if ($prop->isPrivate()) $type = 'private';
            elseif ($prop->isProtected()) $type = 'protected';
            else $type = 'public';

            $type = $prop->isStatic() ? $type . ' static' : $type;

            $out .= "$type {$D}{$prop->name};" . PHP_EOL;
        }
        return $out;
    }

    /**
     * @param ReflectionClass $rClass
     * @return string
     */
    public function getMethods($rClass)
    {
        $out = "";
        foreach ($rClass->getMethods() as $method) {
            if ($rClass->name !== $method->class) {
                continue;
            }

            if ($method->isPrivate()) $type = 'private';
            elseif ($method->isProtected()) $type = 'protected';
            else $type = 'public';

            $type = $method->isFinal() ? 'final ' . $type : $type;
            $type = $method->isAbstract() ? 'abstract ' . $type : $type;
            $type = $method->isStatic() ? $type . ' static' : $type;

            $body = $method->isAbstract() ? ";" : " {". $this->methodBody($method->name) ."}";

            $out .= $method->getDocComment() ? "    " . $method->getDocComment() . PHP_EOL : "";
            $out .= "    ";
            $out .= "$type function {$method->name}(". $this->methodParams($method) .")$body" . PHP_EOL;
        }
        return $out;
    }

    /**
     * @param ReflectionMethod $rMethod
     * @return string
     */
    public function methodParams($rMethod)
    {
        $params = [];
        foreach ($rMethod->getParameters() as $rParam) {
            $name = '$' . $rParam->name;
            $default = '';
            if ($hasDefault = $rParam->isDefaultValueAvailable()) {
                $default = $rParam->getDefaultValue();
                if ($default === []) $default = '[]';
                elseif ($default === null) $default = 'null';
                elseif (is_bool($default)) $default = $default ? 'true' : 'false';
                elseif (is_string($default)) $default = "'$default'";
                elseif (is_numeric($default)) {}
                else $default = "'(". gettype($default) ." content)'";
            }

            if ($rParam->isArray()) $type = 'array';
            elseif ($rParam->isCallable()) $type = '\\Closure';
            else $type = '';

            $ref = $rParam->isPassedByReference() ? "&" : "";
            $params[] = trim("$type {$ref}{$name}" . ($hasDefault ? " = $default" : ""));
        }
        return implode(", ", $params);
    }

    public function methodBody($name)
    {
        switch ($name) {
            case '__toString': return ' return ""; ';
            default: return '';
        }
    }

    public function walkOnClasses(\Closure $func)
    {
        for ($i = 0; $i < count($this->classes); $i++) {
            $class = $this->classes[$i];
            try {
                $rClass = new ReflectionClass($class);
            }
            catch (Exception $ex) { continue; }

            if (!in_array($class, $this->createdClasses)) {
                if ($pClass = $rClass->getParentClass() and !in_array($pClass->name, $this->classes)) {
                    $this->classes[] = $pClass->name;
                }

                $traits = [];
                foreach ($rClass->getTraits() as $trait) {
                    $traits[] = $trait->name;
                    if (!in_array($trait->name, $this->classes)) {
                        $this->classes[] = $trait->name;
                    }
                }

                $this->createdClasses[] = $class;
                $func($rClass, $pClass ? $pClass->name : false, $traits);
            }
        }
    }
}