<?php
namespace greenweb\core\models;

use greenweb\core\base\PrimaryObject;
use greenweb\core\helpers\Helper;

class Model extends PrimaryObject
{
    public function attributes()
    {
        return Helper::getPublicProperties($this);
    }

    public function data()
    {
        $props = [];
        foreach($this->attributes() as $prop) {
            $props[$prop] = $this->{$prop};
        }
        return $props;
    }

    /**
     * @var array List of attributes which you want to prevent massive load.
     */
    protected $disabledAttributes = [];

    public function load(array $data, $loadDisabled = false)
    {
        $attributes = $this->attributes();
        if(!$loadDisabled) {
            $attributes = array_diff($attributes, $this->disabledAttributes);
        }
        $filters = $this->filters();
        $success = false;
        foreach($data as $key => $value) {
            if(in_array($key, $attributes)) {
                if(isset($filters[$key])) {
                    foreach ((array)$filters[$key] as $func) {
                        $value = $func($value);
                    }
                }
                $this->{$key} = $value;
                $success = true;
            }
        }
        return $success;
    }

    /**
     * @return array List of filters you want to use when loading data.
     */
    public function filters()
    {
        return [];
    }

    public function rules()
    {
        return [];
    }

    public function validate()
    {
        $valid = true;
        foreach($this->rules() as $prop => $val) {
            if (!$val) {
                $valid = false;
                $this->setError($prop, 'Model validation error.');
            }
        }
        return $valid;
    }

    private $errors = [];

    public function getErrors()
    {
        return $this->errors;
    }

    public function setError($attribute, $error)
    {
        $this->errors[$attribute] = $error;
    }
}