<?php
namespace greenweb\core\helpers;

class UrlHelper
{
    /**
     * @param $url string Input url which you want to make standard.
     * @param $preSlash bool add slash before url.
     * @return string Standard url without end slash.
     */
    public static function standard($url, $preSlash = false)
    {
        $url = rtrim(str_replace('\\', '/', $url), '/');
        return $preSlash ? '/' . ltrim($url, '/') : $url;
    }
}