<?php
namespace greenweb\core\helpers;

class ArrayHelper
{
    /**
     * @param $array array Which you want to map its nodes to array.
     * @return array Mapped array.
     */
    public static function mapToArray(array $array)
    {
        return array_map(function($a) { return (array)$a; }, $array);
    }

    /**
     * @param $array array Which you want to get column.
     * @param $column string Column name.
     * @return array Data of selected column.
     */
    public static function arrayColumn(array $array, $column)
    {
        return array_column(self::mapToArray($array), $column);
    }

    public static function parentChildSort(array $array)
    {
        $id = 'id';
        $pId = 'parent_id';
        $pos = 'position';
        $child = 'children';

        $arr = [];
        foreach($array as $key => $row) {
            $array[$key] = $array[$key] + [$child => []];
            $arr[$row[$id]] = &$array[$key];
        }

        $roots = [];
        foreach($arr as $key => $row) {
            if(isset($arr[$row[$pId]])) {
                $arr[$row[$pId]][$child][$key] = &$arr[$key];
            } else {
                $roots[$key] = true;
            }
        }

        foreach($arr as $key => $row) {
            uasort($arr[$key][$child], function($a, $b) use ($pos) {
                return $a[$pos] > $b[$pos] ? 1 : -1;
            });
        }

        return array_intersect_key($arr, $roots);
    }

    public static function nestedToLinear(array $array, &$ret)
    {
        $child = 'children';

        foreach($array as $key => $row) {
            $ret[] = $array[$key];
            self::nestedToLinear($array[$key][$child], $ret);
        }
    }

    public static function flip(array $array, $field = null)
    {
        if($field === null) {
            return array_flip($array);
        } else {
            $tmp = [];
            foreach($array as $key => $data) {
                $data = (array)$data;
                $id = $data[$field];
                $data[$field] = $key;
                $tmp[$id] = $data;
            }
            return $tmp;
        }
    }

    public static function merge($a, $b)
    {
        $args = func_get_args();
        $res = array_shift($args);
        while (!empty($args)) {
            $next = array_shift($args);
            foreach ($next as $k => $v) {
                if (is_int($k)) {
                    if (isset($res[$k])) {
                        $res[] = $v;
                    } else {
                        $res[$k] = $v;
                    }
                } elseif (is_array($v) && isset($res[$k]) && is_array($res[$k])) {
                    $res[$k] = self::merge($res[$k], $v);
                } else {
                    $res[$k] = $v;
                }
            }
        }
        return $res;
    }

    public static function remove(array &$array, $key, $default = null)
    {
        $value = isset($array[$key]) ? $array[$key] : $default;
        unset($array[$key]);
        return $value;
    }
}