<?php
namespace greenweb\core\drawing;

use greenweb\core\base\PrimaryObject;

class Style extends PrimaryObject
{
    public $paddingTop;
    public $paddingStart;
    public $paddingBottom;
    public $paddingEnd;
    public $x;
    public $y;
    public $width;
    public $height;
    public $fontFamily;
    public $fontSize;
    public $color;
    public $backgroundColor;
    public $borderColor;
    public $borderWidth;

    /**
     * @var Canvas
     */
    public $img;

    public function convertProperties()
    {
        return [
            'paddingTop' => 'height',
            'paddingStart' => 'width',
            'paddingBottom' => 'height',
            'paddingEnd' => 'width',
            'x' => 'width',
            'y' => 'height',
            'width' => 'width',
            'height' => 'height',
            'color' => 'color',
            'backgroundColor' => 'color',
            'borderColor' => 'color',
            'borderWidth' => '-'
        ];
    }

    public function init()
    {
        $img = $this->img;
        foreach ($this->convertProperties() as $prop => $convert) {
            $v = $this->{$prop};
            if ($v !== null) {
                if ($convert == 'width') {
                    $this->{$prop} = $img->w($v);
                }
                elseif ($convert == 'height') {
                    $this->{$prop} = $img->h($v);
                }
                elseif ($convert == 'color' and is_array($v)) {
                    $this->{$prop} = call_user_func_array([$img, 'color'], $v);
                }
            }
        }
    }
}