<?php
namespace greenweb\core\download;

use greenweb\core\base\Download;

class HttpDownload extends Download
{
    public $url;

    public $options = [];

    public function init()
    {
        parent::init();

        $options = [
            CURLOPT_TIMEOUT => 50,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_FOLLOWLOCATION => true
        ];

        $this->options = $options + $this->options;
    }

    public function download()
    {
        try {
            $pointer = fopen($this->fileName, 'w+');
            $this->options[CURLOPT_FILE] = $pointer;
            $ch = curl_init($this->url);
            foreach ($this->options as $key => $value) {
                curl_setopt($ch, $key, $value);
            }
            curl_exec($ch);
            curl_close($ch);
            fclose($pointer);
            return true;
        } catch (\Exception $ex) {
            return false;
        }
    }

    private $remoteFileName;
    public function remoteFileName()
    {
        if($this->remoteFileName === null) {
            $data = get_headers($this->url);
            foreach($data as $row) {
                if(preg_match('/filename="([^\"]+)"/', $row, $matches)) {
                    $this->remoteFileName = $matches[1];
                    break;
                }
            }

            if($this->remoteFileName === null) {
                $path = parse_url($this->url, PHP_URL_PATH);
                $this->remoteFileName = basename($path);
            }
        }

        return $this->remoteFileName;
    }
}