<?php
namespace greenweb\core\base;

class Formatter extends Component
{
    public $date = "Y-m-d";
    public $time = "H:i:s";
    public $dateTime = "Y-m-d H:i:s";

    /**
     * @var int Represent time seed. you can set time() function return value here.
     */
    public $baseTime;

    public function now()
    {
        return $this->phpDate($this->dateTime, $this->baseTime);
    }

    public function date()
    {
        return $this->phpDate($this->date, $this->baseTime);
    }

    public function time()
    {
        return $this->phpDate($this->time, $this->baseTime);
    }

    public function byteToMegabyte($byte)
    {
        return $byte / (1024 * 1024);
    }

    private function phpDate($format, $timestamp = null)
    {
        return ($timestamp === null ? date($format) : date($format, $timestamp));
    }
}