<?php
namespace greenweb\core\base;

use greenweb\core\App;

abstract class Cache extends Component
{
    public $path;

    private $oldCacheInfo;

    public function init()
    {
        if($this->path === null and !($this->app instanceof App)) {
            throw new \Exception("Property 'path' can not be null.");
        }elseif($this->path === null) {
            $this->path = $this->app->rootDir() . "/runtime/cache";
        }
    }

    public function set($key, $data)
    {
        $data = serialize([$data, $this->cacheInfo()]);
        $key = md5($key);
        @mkdir($this->getPath($key), 0755, true);
        return file_put_contents($this->getPath($key) . "/$key", $data);
    }

    public function get($key, $validate = true)
    {
        $key = md5($key);
        $fileName = $this->getPath($key) . "/$key";

        if(!is_file($fileName)) {
            return null;
        }

        $file = file_get_contents($this->getPath($key) . "/$key");
        $file = unserialize($file);
        $this->oldCacheInfo = @$file[1];

        if($validate and !$this->validate($this->oldCacheInfo)) {
            return null;
        }

        return @$file[0];
    }

    public function validate($cacheInfo)
    {
        return $cacheInfo === $this->cacheInfo();
    }

    public function cacheInfo()
    {
        return null;
    }

    public function oldCacheInfo()
    {
        return $this->oldCacheInfo;
    }

    protected function getPath($key)
    {
        $fl = substr($key, 0, 1);
        return $this->path . "/$fl";
    }
}