<?php
namespace greenweb\core\models;

use greenweb\core\helpers\ArrayHelper;
use Illuminate\Database\Capsule\Manager as Capsule;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\QueryException;

class KVPModel extends Model
{
    public function init()
    {
        parent::init();
        $cycle = 0;
        cycle:
        try {
            $data = Capsule::table(static::tableName())->get();
        } catch (QueryException $ex) {
            if ($cycle == 0 and $ex->getCode() == '42S02') {
                /** If table or view not found. */
                static::createTable();
                $cycle++;
                goto cycle;
            }
            throw $ex;
        }

        if ($data) {
            $this->load(array_column(ArrayHelper::mapToArray($data), 'value', 'key'));
        }
    }

    public function save()
    {
        $prop = [];
        foreach($this->attributes() as $key) {
            $prop[] = ['key' => $key, 'value' => $this->{$key}];
        }

        Capsule::connection()->beginTransaction();
        Capsule::table(static::tableName())->delete();
        if ($prop and $ret = Capsule::table(static::tableName())->insert($prop)) {
            Capsule::connection()->commit();
            return $ret;
        }
        Capsule::connection()->rollBack();
        return false;
    }

    public static function createTable()
    {
        if(!Capsule::schema()->hasTable(static::tableName())) {
            Capsule::schema()->create(static::tableName(), function ($table) {
                /** @var Blueprint $table */
                $table->string('key', 50);
                $table->string('value');

                $table->primary('key');
                $table->engine = 'InnoDB';
            });
        }
    }

    /**
     * @throws \Exception if not override this method.
     * @return string Table name.
     */
    public static function tableName()
    {
        throw new \Exception("Table name is not declared.");
    }
}