<?php
namespace greenweb\core\events;

trait EventsTrait
{
    public static function on($eventName, callable $func)
    {
        Events::addEventHandler(get_called_class(), $eventName, $func);
    }

    public function trigger($eventName, BaseEventData $data)
    {
        $data->owner = $this;
        Events::trigger(get_called_class(), $eventName, $data);
    }
}