<?php
namespace greenweb\core\events;

use greenweb\core\base\PrimaryObject;

class Events extends PrimaryObject
{
    private static $events = [];

    public static function addEventHandler($className, $eventName, callable $func)
    {
        static::$events[$className][] = [
            'className' => $className,
            'eventName' => $eventName,
            'handler' => $func
        ];
    }

    public static function trigger($className, $eventName, BaseEventData $data)
    {
        if (isset(self::$events[$className])) {
            $events = self::$events[$className];

            if (is_array($events)) foreach ($events as $event) {

                if ($event['eventName'] === $eventName) {
                    $data->ownerName = $className;
                    $data->eventName = $eventName;
                    call_user_func($event['handler'], $data);
                }
            }
        }
    }
}